﻿namespace Hims.Api.Controllers
{
    using System;
    using System.Collections.Generic;
    using System.Linq;
    using System.Threading.Tasks;
    using Domain.Services;
    using Hims.Api.Models;
    using Hims.Shared.UserModels.TemplateDesign.Component;
    using Microsoft.AspNetCore.Authorization;
    using Microsoft.AspNetCore.Mvc;
    using Microsoft.CodeAnalysis.CSharp;
    using Npgsql;
    using Shared.DataFilters;
    using Shared.EntityModels;
    using Shared.Library.Enums;
    using Shared.UserModels;
    using Utilities;

    /// <inheritdoc />
    [Authorize]
    [Route("api/component")]
    [Consumes("application/json")]
    [Produces("application/json")]
    public class ComponentController : BaseController
    {
        /// <summary>
        /// The component type services.
        /// </summary>
        private readonly IComponentService componentService;

        /// <summary>
        /// The audit log services.
        /// </summary>
        private readonly IAuditLogService auditLogServices;

        /// <inheritdoc />
        public ComponentController(IComponentService componentService, IAuditLogService auditLogServices)
        {
            this.componentService = componentService;
            this.auditLogServices = auditLogServices;
        }

        /// <summary>
        /// Inserts the hoc asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        [HttpPost]
        [Route("insert")]
        public async Task<ActionResult> InsertHocAsync([FromBody] InsertModel model)
        {
            model = (InsertModel)EmptyFilter.Handler(model);
            var response = await this.componentService.InsertAsync(model);
            return this.Success(response);
        }

        /// <summary>
        /// Inserts the hoc asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        [HttpPost]
        [Route("update")]
        public async Task<ActionResult> UpdateHocAsync([FromBody] UpdateModel model)
        {
            model = (UpdateModel)EmptyFilter.Handler(model);
            var response = await this.componentService.UpdateAsync(model);
            return this.Success(response);
        }

        /// <summary>
        /// Fetches all asynchronous.
        /// </summary>
        /// <param name="model">The model.</param>
        /// <returns></returns>
        [HttpPost]
        [Route("fetch-all")]
        public async Task<ActionResult> FetchAllAsync([FromBody] FetchModel model)
        {
            model ??= new FetchModel();
            var response = await this.componentService.FetchAllAsync(model);
            return this.Success(response);
        }
    }
}